static const char* script_lib_image_string =
  "Image.Adopt = fun (raw_image)\n"
  "{\n"
  "  if (raw_image) return raw_image | [] | Image;\n"
  "  else return NULL;\n"
  "};\n"
  "\n"
  "Image.Rotate = fun (angle)\n"
  "{\n"
  "  return Image.Adopt (this._Rotate(angle));\n"
  "};\n"
  "\n"
  "Image.Crop = fun (x, y, width, height)\n"
  "{\n"
  "  return Image.Adopt (this._Crop(x, y, width, height));\n"
  "};\n"
  "\n"
  "Image.Scale = fun (width, height)\n"
  "{\n"
  "  return Image.Adopt (this._Scale(width, height));\n"
  "};\n"
  "\n"
  "Image.Tile = fun (width, height)\n"
  "{\n"
  "  return Image.Adopt (this._Tile(width, height));\n"
  "};\n"
  "\n"
  "Image.Text = fun (text, red, green, blue, alpha, font, align)\n"
  "{\n"
  "  return Image.Adopt (Image._Text (text, red, green, blue, alpha, font, align));\n"
  "};\n"
  "\n"
  "Image |= fun (filename)\n"
  "{\n"
  "  return Image.Adopt (Image._New(filename));\n"
  "};\n"
  "\n"
  "#------------------------- Compatability Functions -------------------------\n"
  "\n"
  "fun ImageNew (filename)\n"
  "{\n"
  "  return Image (filename);\n"
  "}\n"
  "\n"
  "fun ImageScale (image, width, height)\n"
  "{\n"
  "  return image.Scale (width, height);\n"
  "}\n"
  "\n"
  "fun ImageRotate (image, angle)\n"
  "{\n"
  "  return image.Rotate (angle);\n"
  "}\n"
  "\n"
  "fun ImageGetWidth (image)\n"
  "{\n"
  "  return image.GetWidth ();\n"
  "}\n"
  "\n"
  "fun ImageGetHeight (image)\n"
  "{\n"
  "  return image.GetHeight ();\n"
  "}\n"
;
